package dev.gegy.mdchat;// Created 2022-04-03T02:52:00

import org.commonmark.node.Node;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_5250;

/**
 * @author KJP12
 * @since ${version}
 **/
public interface NodeStyler {
    Function<NodeStyler[], NodeStyler> EVENT_INVOKER = callbacks -> (node, textSupplier) -> {
        for (NodeStyler styler : callbacks) {
            class_5250 text = styler.style(node, textSupplier);
            if (text != null) return text;
        }
        return null;
    };

    /**
     * Styles the given markdown node & formatted child text into Minecraft-formatted text.
     *
     * @param node         The markdown node to format.
     * @param textSupplier The supplier for the child nodes.
     * @return If handled, a maybe formatted Minecraft text node, else null.
     */
    @Nullable class_5250 style(Node node, Supplier<class_5250> textSupplier);
}
