/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.mdchat;

import dev.gegy.mdchat.NodeStyler;
import dev.gegy.mdchat.TextStyler;
import dev.gegy.mdchat.parser.ColoredChatExtension;
import dev.gegy.mdchat.parser.FormattedNode;
import dev.gegy.mdchat.parser.SpoilerExtension;
import dev.gegy.mdchat.parser.SpoilerNode;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.node.Code;
import org.commonmark.node.Emphasis;
import org.commonmark.node.Link;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;

public final class BuiltinStylers {
    public static final NodeStyler LITERAL = (node, innerContent) -> {
        if (node instanceof Text) {
            Text text = (Text)node;
            return class_2561.method_43470((String)text.getLiteral());
        }
        return null;
    };
    public static final NodeStyler CODE = (node, innerContent) -> {
        if (node instanceof Code) {
            Code code = (Code)node;
            String literal = code.getLiteral();
            class_5250 text = class_2561.method_43470((String)literal).method_27692(class_124.field_1080);
            if (literal.startsWith("/")) {
                return text.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to Copy to Console"))).method_10958(new class_2558(class_2558.class_2559.field_11745, literal)));
            }
            return text.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))).method_10958(new class_2558(class_2558.class_2559.field_21462, literal)));
        }
        return null;
    };
    public static final NodeStyler BOLD = (node, innerContent) -> {
        if (node instanceof StrongEmphasis) {
            String delimiter;
            StrongEmphasis emphasis = (StrongEmphasis)node;
            if (innerContent != null && (delimiter = emphasis.getOpeningDelimiter()).equals("**")) {
                return innerContent.method_27692(class_124.field_1067);
            }
        }
        return null;
    };
    public static final NodeStyler UNDERLINE = (node, innerContent) -> {
        if (node instanceof StrongEmphasis) {
            String delimiter;
            StrongEmphasis emphasis = (StrongEmphasis)node;
            if (innerContent != null && (delimiter = emphasis.getOpeningDelimiter()).equals("__")) {
                return innerContent.method_27692(class_124.field_1073);
            }
        }
        return null;
    };
    public static final NodeStyler ITALIC = (node, innerContent) -> {
        if (node instanceof Emphasis && innerContent != null) {
            return innerContent.method_27692(class_124.field_1056);
        }
        return null;
    };
    public static final NodeStyler STRIKETHROUGH = (node, innerContent) -> {
        if (node instanceof Strikethrough && innerContent != null) {
            return innerContent.method_27692(class_124.field_1055);
        }
        return null;
    };
    public static final NodeStyler LINK = (node, innerContent) -> {
        if (node instanceof Link) {
            Link link = (Link)node;
            class_5250 title = Objects.requireNonNullElseGet(innerContent, () -> class_2561.method_43470((String)link.getDestination()));
            class_5250 redirectsTo = class_2561.method_43470((String)"Goes to ").method_10852((class_2561)class_2561.method_43470((String)link.getDestination()).method_27695(new class_124[]{class_124.field_1075, class_124.field_1073})).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
            String hoverText = link.getTitle();
            class_5250 hover = hoverText != null ? class_2561.method_43470((String)hoverText).method_27693("\n\n").method_10852((class_2561)redirectsTo) : redirectsTo;
            return title.method_10862(BuiltinStylers.buildLinkStyle(link.getDestination(), hover));
        }
        return null;
    };
    public static final NodeStyler FORMATTED = (node, innerContent) -> {
        if (node instanceof FormattedNode) {
            FormattedNode formatted = (FormattedNode)node;
            if (innerContent != null) {
                return innerContent.method_27692(formatted.getFormatting());
            }
        }
        return null;
    };
    private static final class_2583 SPOILER_STYLE = class_2583.field_24360.method_27705(new class_124[]{class_124.field_1063, class_124.field_1051});
    public static final NodeStyler SPOILER = (node, innerContent) -> {
        if (node instanceof SpoilerNode && innerContent != null) {
            return innerContent.method_27661().method_10862(SPOILER_STYLE.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)innerContent)));
        }
        return null;
    };

    private static class_2583 buildLinkStyle(String url, class_5250 hover) {
        return class_2583.field_24360.method_27705(new class_124[]{class_124.field_1075, class_124.field_1073}).method_10958(new class_2558(class_2558.class_2559.field_11749, url)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover));
    }

    public static void addTo(TextStyler.Builder builder) {
        NodeStyler styler = NodeStyler.compose(LITERAL, CODE, BOLD, UNDERLINE, ITALIC, STRIKETHROUGH, LINK, FORMATTED, SPOILER);
        builder.addNodeStyler(styler);
        builder.addExtensions(List.of(ColoredChatExtension.INSTANCE, SpoilerExtension.INSTANCE, AutolinkExtension.create(), StrikethroughExtension.create()));
    }
}

