/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.mdchat;

import dev.gegy.mdchat.NodeStyler;
import dev.gegy.mdchat.StylerBootstrap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7492;
import org.commonmark.Extension;
import org.commonmark.node.Block;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.parser.PostProcessor;
import org.commonmark.parser.block.BlockParserFactory;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.jetbrains.annotations.Nullable;

public final class TextStyler
implements class_7492 {
    public static final TextStyler INSTANCE = TextStyler.builderWithGlobal().build();
    private final NodeStyler styler;
    private final Parser parser;

    private TextStyler(NodeStyler styler, Parser parser) {
        this.styler = styler;
        this.parser = parser;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderWithGlobal() {
        Builder stylerBuilder = new Builder();
        StylerBootstrap.global().bootstrap(stylerBuilder);
        return stylerBuilder;
    }

    @Nullable
    public class_2561 apply(String string) {
        Node node = this.parser.parse(string);
        return this.render(node);
    }

    @Nullable
    public class_2561 apply(class_2561 text) {
        return this.apply(text.getString());
    }

    public CompletableFuture<class_2561> decorate(@Nullable class_3222 sender, class_2561 message) {
        return CompletableFuture.completedFuture(this.apply(message));
    }

    @Nullable
    private class_5250 render(Node node) {
        class_5250 innerContent = this.renderInnerContent(node);
        class_5250 styledContent = this.styler.style(node, innerContent);
        return styledContent != null ? styledContent : innerContent;
    }

    @Nullable
    private class_5250 renderInnerContent(Node parent) {
        class_5250 result = null;
        Node child = parent.getFirstChild();
        while (child != null) {
            Node next = child.getNext();
            class_5250 text = this.render(child);
            if (text != null) {
                if (result == null) {
                    result = class_2561.method_43473();
                }
                result = result.method_10852((class_2561)text);
            }
            child = next;
        }
        return result;
    }

    public static final class Builder {
        private final List<NodeStyler> nodeStylers = new ArrayList<NodeStyler>();
        private final Parser.Builder parser = Parser.builder();
        private final Set<Class<? extends Block>> enabledBlockTypes = new ReferenceOpenHashSet();

        private Builder() {
        }

        public void addNodeStyler(NodeStyler nodeStyler) {
            this.nodeStylers.add(nodeStyler);
        }

        public Builder addExtension(Extension extension) {
            return this.addExtensions(List.of(extension));
        }

        public Builder addExtensions(Iterable<? extends Extension> extensions) {
            this.parser.extensions(extensions);
            return this;
        }

        public Builder enableBlockType(Class<? extends Block> blockType) {
            this.enabledBlockTypes.add(blockType);
            return this;
        }

        public Builder addBlockParserFactory(BlockParserFactory blockParserFactory) {
            this.parser.customBlockParserFactory(blockParserFactory);
            return this;
        }

        public Builder addDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            this.parser.customDelimiterProcessor(delimiterProcessor);
            return this;
        }

        public Builder addPostProcessor(PostProcessor postProcessor) {
            this.parser.postProcessor(postProcessor);
            return this;
        }

        public TextStyler build() {
            NodeStyler nodeStyler = NodeStyler.compose((NodeStyler[])this.nodeStylers.toArray(NodeStyler[]::new));
            Parser parser = this.parser.enabledBlockTypes(this.enabledBlockTypes).build();
            return new TextStyler(nodeStyler, parser);
        }
    }
}

