/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.mdchat.parser;

import dev.gegy.mdchat.parser.FormattedNode;
import net.minecraft.class_124;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public final class ColoredChatExtension
implements Parser.ParserExtension {
    public static final Extension INSTANCE = new ColoredChatExtension();

    private ColoredChatExtension() {
    }

    public void extend(Parser.Builder builder) {
        builder.customDelimiterProcessor((DelimiterProcessor)new FormatDelimiterProcessor());
    }

    private static class FormatDelimiterProcessor
    implements DelimiterProcessor {
        private static final char DELIMITER = '^';

        private FormatDelimiterProcessor() {
        }

        public char getOpeningCharacter() {
            return '^';
        }

        public char getClosingCharacter() {
            return '^';
        }

        public int getMinLength() {
            return 1;
        }

        public int process(DelimiterRun openerRun, DelimiterRun closerRun) {
            if (openerRun.length() >= 1 && closerRun.length() >= 1) {
                this.process(openerRun.getOpener(), openerRun.getCloser());
                return 1;
            }
            return 0;
        }

        private void process(Text opener, Text closer) {
            class_124 targetFormat = null;
            Node first = opener.getNext();
            if (first instanceof Text) {
                Text firstText = (Text)first;
                String literal = firstText.getLiteral();
                firstText.setLiteral(literal.substring(1));
                char code = Character.toLowerCase(literal.charAt(0));
                for (class_124 format : class_124.values()) {
                    if (format.field_1059 != code) continue;
                    targetFormat = format;
                    break;
                }
            }
            if (targetFormat != null) {
                FormattedNode formatted = new FormattedNode(targetFormat);
                this.insertBetween(opener, closer, (Node)formatted);
            }
        }

        private void insertBetween(Text opener, Text closer, Node node) {
            Node sibling = opener.getNext();
            while (sibling != null && sibling != closer) {
                Node next = sibling.getNext();
                node.appendChild(sibling);
                sibling = next;
            }
            opener.insertAfter(node);
        }
    }
}

