/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.mdchat.parser;

import dev.gegy.mdchat.parser.SpoilerNode;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.parser.delimiter.DelimiterProcessor;
import org.commonmark.parser.delimiter.DelimiterRun;

public final class SpoilerExtension
implements Parser.ParserExtension {
    public static final Extension INSTANCE = new SpoilerExtension();

    private SpoilerExtension() {
    }

    public void extend(Parser.Builder builder) {
        builder.customDelimiterProcessor((DelimiterProcessor)new SpoilerDelimiterProcessor());
    }

    private static class SpoilerDelimiterProcessor
    implements DelimiterProcessor {
        private static final char DELIMITER = '|';

        private SpoilerDelimiterProcessor() {
        }

        public char getOpeningCharacter() {
            return '|';
        }

        public char getClosingCharacter() {
            return '|';
        }

        public int getMinLength() {
            return 2;
        }

        public int process(DelimiterRun openerRun, DelimiterRun closerRun) {
            if (openerRun.length() >= 2 && closerRun.length() >= 2) {
                this.process(openerRun.getOpener(), openerRun.getCloser());
                return 2;
            }
            return 0;
        }

        private void process(Text opener, Text closer) {
            SpoilerNode spoiler = new SpoilerNode();
            Node node = opener.getNext();
            while (node != null && node != closer) {
                Node next = node.getNext();
                spoiler.appendChild(node);
                node = next;
            }
            opener.insertAfter((Node)spoiler);
        }
    }
}

